#include "CommunicationDecoder.h"
#include <iostream>
#include <sstream>


namespace Communication
{

CommunicationDecoder::CommunicationDecoder()
{
	controller = new CommunicationController();
	syncflag = false;
}

CommunicationDecoder::~CommunicationDecoder()
{
	this->FreeResources();
	delete controller;
}

void CommunicationDecoder::FreeResources()
{
	controller->FreeResources();
}

void CommunicationDecoder::ProcessMessage(string messagetext, bool broadcast, bool sync)
{
	if (broadcast)
	{
		if (sync==false)
		{
			controller->BroadcastMessage(messagetext);
			return;
		}		
		else
		{
			XMLNode xMainNode=XMLNode::parseString(messagetext.data(),"WorldBroadcastSync");				
			controller->BroadcastMessage(messagetext);
			string itertext = xMainNode.getChildNode("Iteration").getText();
			int iteration = atoi(itertext.data());
			controller->ResetSynchronization(iteration);
			syncflag=true;
			if (!controller->SyncRemaining())
			{
				syncflag = false;
				string simmsg = "<Simulation_Message><Control_Request Command=\"Synchronize\"><Iteration>"+itertext+"<Iteration></Control_Request></Simulation_Message>";
				controller->ForwardMessage(simmsg);
			}
			return;
		}
		
	}
	XMLNode xMainNode=XMLNode::parseString(messagetext.data(),"Message");
	int childnumber=0;
	while (!xMainNode.getChildNode(childnumber).isEmpty())
	{
		XMLNode message = xMainNode.getChildNode(childnumber);
		
		if (strcmp(message.getName(),"Simulation_Message")==0)
		{
			char *varaux = message.createXMLString(false);
			string toforward = varaux;
			controller->ForwardMessage(toforward);			
						
			free(varaux);
		}
		else if (strcmp(message.getName(),"Agent_Message")==0)
		{ 			
			if (strcmp(message.getAttribute("Command"),"Register_Agent")==0)
			{
				string key = message.getChildNode("Key").getText();
				if (controller->ExistsAgent(key))
				{
					controller->BroadcastResponse("<Response>ERROR: Already exists agent with key:"+key+ "</Response>");
					return;
				}
				if (strcmp(message.getAttribute("Agent_Type"),"GUI")==0)
				{
					int port = atoi(message.getChildNode("Port").getText());
					string ip = message.getChildNode("IP").getText();
					double broadcastinterval = atof(message.getChildNode("Broadcast").getText());
					string sync = message.getChildNode("Sync").getText();
					bool syncmode = false;
					if (sync=="true")
						syncmode =true;					
					controller->AddAgent(new DataGUIAgent(port,ip,broadcastinterval, syncmode,key));
					stringstream portstr;
					portstr<<port;
					controller->BroadcastResponse("<Response>Sucessfully added agent with key:"+key+ ", port:"+portstr.str()+" and IP:"+ip +"</Response>");
				}
				else if (strcmp(message.getAttribute("Agent_Type"),"RobotController")==0)
				{
					int port = atoi(message.getChildNode("Port").getText());
					string ip = message.getChildNode("IP").getText();
					double broadcastinterval = atof(message.getChildNode("Broadcast").getText());
					string sync = message.getChildNode("Sync").getText();
					bool syncmode = false;
					if (sync=="true")
						syncmode =true;				
					XMLNode robotsnode= message.getChildNode("Robots");
					list<int> robotids;
					if (!robotsnode.isEmpty())
					{
						int robotnumber=0;
						while (!robotsnode.getChildNode(robotnumber).isEmpty())
						{
							int robotid = atoi (robotsnode.getChildNode(robotnumber).getText());
							robotids.push_back(robotid);
							robotnumber++;
						}
					}					
					controller->AddAgent(new DataRobotControllerAgent(port, ip, broadcastinterval,syncmode, robotids,key));
					stringstream portstr;
					portstr<<port;
					controller->BroadcastResponse("<Response>Sucessfully added agent with key:"+key+ ", port:"+portstr.str()+" and IP:"+ip +"</Response>");
				}
			}
			else if (strcmp(message.getAttribute("Command"),"Synchronize")==0 && syncflag)
			{
				string key = message.getChildNode("Key").getText();
				string itertext = message.getChildNode("Iteration").getText();
				int iteration = atoi(itertext.data());
				controller->SynchronizeAgent(key,iteration);
				if (!controller->SyncRemaining())
				{
					syncflag = false;
					string simmsg = "<Simulation_Message><Control_Request Command=\"Synchronize\"><Iteration>"+itertext+"<Iteration></Control_Request></Simulation_Message>";
					controller->ForwardMessage(simmsg);
				}
			}
			else if (strcmp(message.getAttribute("Command"),"Info_Request")==0)
			{				
				string keyrequester = message.getChildNode("Requester").getText();
				string keyrequested = message.getChildNode("Requested").getText();
				if (keyrequester.length()>0 && keyrequested.length()>0)
				{
					controller->AgentInfoRequest(keyrequester, keyrequested);
				}
			}
				
		}
		else if (strcmp(message.getName(),"From_Simulation")==0)
		{ 
			/*Deprecated*/
			if (strcmp(message.getAttribute("Command"),"WorldBroadcast")==0)
			{
				string tobroadcast = "<BroadcastSync>";
				char *varaux0=message.getChildNode(0).createXMLString(false);
				char *varaux1=message.getChildNode(1).createXMLString(false);
				char *varaux2=message.getChildNode(2).createXMLString(false);
				tobroadcast += varaux0;
				tobroadcast += varaux1;
				tobroadcast += varaux2;
				tobroadcast+= "</BroadcastSync>";
				controller->BroadcastMessage(tobroadcast);								
				free(varaux0); free(varaux1); free(varaux2);
				
			}
			/*Deprecated*/
			else if (strcmp(message.getAttribute("Command"),"WorldBroadcastSync")==0)
			{				
				char *varaux0=message.getChildNode(0).createXMLString(false);
				char *varaux1=message.getChildNode(1).createXMLString(false);
				char *varaux2=message.getChildNode(2).createXMLString(false);								
				string tobroadcast = "<Broadcast>";
				tobroadcast += varaux0;
				tobroadcast += varaux1;
				tobroadcast += varaux2;
				tobroadcast+= "</Broadcast>";				
				controller->BroadcastMessage(tobroadcast);
				free(varaux0); free(varaux1); free(varaux2);
				string itertext = message.getChildNode("Iteration").getText();
				int iteration = atoi(itertext.data());
				controller->ResetSynchronization(iteration);
				syncflag=true;
				if (!controller->SyncRemaining())
				{
					syncflag = false;
					string simmsg = "<Simulation_Message><Control_Request Command=\"Synchronize\"><Iteration>"+itertext+"<Iteration></Control_Request></Simulation_Message>";
					controller->ForwardMessage(simmsg);
				}
				
			}
			else if (strcmp(message.getAttribute("Command"),"SyncTimeout")==0)
			{				
				string itertext = message.getChildNode("Iteration").getText();
				int iteration = atoi(itertext.data());
				controller->ResetSynchronization(iteration);
				if (!controller->SyncRemaining())
				{			
					string simmsg = "<Simulation_Message><Control_Request Command=\"Synchronize\"><Iteration>"+itertext+"<Iteration></Control_Request></Simulation_Message>";
					controller->ForwardMessage(simmsg);
				}
				syncflag=false;
			}
		}
		else if (strcmp(message.getName(),"Response")==0)
		{ 
			char *varaux = message.createXMLString(false);
			string response = varaux;
			controller->BroadcastResponse(response);
			free(varaux);
		}
		
		childnumber++;

	}
	xMainNode.deleteNodeContent();
		
}

}
